/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.Serializable;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.particles.EffectsRenderPacket;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.util.TrinketsConfig;

public class MovingThrownProjectile
extends EntityFireball
implements IProjectile {
    private ItemStack stack;
    private HitResult hitResult;
    private int xTile;
    private int yTile;
    private int zTile;
    private Block inTile;
    private int inData;
    protected boolean inGround;
    protected int timeInGround;
    private int ticksInGround;
    private int ticksInAir;
    private double damage;
    private int knockbackStrength;
    public int throwableShake;
    public Entity ignoreEntity;
    private int ignoreTime;
    int color;
    private boolean ignoreBlocks = false;
    int frame = 0;

    public MovingThrownProjectile(World worldIn) {
        super(worldIn);
        this.color = 0xC00000;
    }

    public MovingThrownProjectile(World worldIn, EntityLivingBase shooter, double accelX, double accelY, double accelZ, int color) {
        super(worldIn, shooter, accelX, accelY, accelZ);
        this.color = color;
        float f = -MathHelper.func_76126_a((float)(shooter.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(shooter.field_70125_A * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((shooter.field_70125_A + 0.0f) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(shooter.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(shooter.field_70125_A * ((float)Math.PI / 180)));
        this.damage = TrinketsConfig.SERVER.races.dragon.breath_damage;
        this.func_70105_a(0.5f, 0.5f);
        double d0 = MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
        this.field_70232_b = accelX / d0 * (0.1 * (double)(this.isFlying(shooter) ? 4 : 1));
        this.field_70233_c = accelY / d0 * (0.1 * (double)(this.isFlying(shooter) ? 4 : 1));
        this.field_70230_d = accelZ / d0 * (0.1 * (double)(this.isFlying(shooter) ? 4 : 1));
    }

    private boolean isFlying(EntityLivingBase entity) {
        return entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b;
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += entityThrower.field_70159_w;
        this.field_70179_y += entityThrower.field_70179_y;
        if (!entityThrower.field_70122_E) {
            this.field_70181_x += entityThrower.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public MovingThrownProjectile setIgnoreBlocks(boolean ignoreBlocks) {
        this.ignoreBlocks = ignoreBlocks;
        return this;
    }

    public MovingThrownProjectile setColor(int color) {
        this.color = color;
        return this;
    }

    public void setSizes(float width, float height) {
        this.func_70105_a(width, height);
    }

    protected boolean func_184564_k() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            if (this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile)).func_177230_c() == this.inTile) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.func_70106_y();
                }
                return;
            }
            this.inGround = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_72933_a(vec3d, vec3d1);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        boolean flag = false;
        for (Entity entity1 : list) {
            double d1;
            if (!entity1.func_70067_L()) continue;
            if (entity1 == this.ignoreEntity) {
                flag = true;
                continue;
            }
            if (this.field_70235_a != null && this.field_70173_aa < 2 && this.ignoreEntity == null) {
                this.ignoreEntity = entity1;
                flag = true;
                continue;
            }
            flag = false;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f);
            RayTraceResult raytraceresult1 = axisalignedbb.func_72327_a(vec3d, vec3d1);
            if (raytraceresult1 == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (this.ignoreEntity != null) {
            if (flag) {
                this.ignoreTime = 2;
            } else if (this.ignoreTime-- <= 0) {
                this.ignoreEntity = null;
            }
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(raytraceresult.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(raytraceresult.func_178782_a());
            } else if (!ForgeEventFactory.onProjectileImpact((EntityFireball)this, (RayTraceResult)raytraceresult)) {
                this.func_70227_a(raytraceresult);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f1 = 0.99f;
        float f2 = 0.03f;
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f1 = 0.8f;
        }
        this.field_70159_w *= (double)f1;
        this.field_70181_x *= (double)f1;
        this.field_70179_y *= (double)f1;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.03f;
        }
        int life = 30;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.spawnParticle();
        if (this.field_70173_aa >= 30) {
            this.func_70106_y();
        }
        if (this.func_70090_H()) {
            this.func_70106_y();
        }
    }

    public void spawnParticle() {
        try {
            Random random = Reference.random;
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            if (d0 * d0 + d1 * d1 + d2 * d2 <= 1.0) {
                double d3 = this.field_70165_t + d0 * 1.0 / 4.0;
                double d4 = this.field_70163_u + 0.5 + d1 * 1.0 / 4.0;
                double d5 = this.field_70161_v + d2 * 1.0 / 4.0;
                if (this.field_70170_p instanceof WorldServer) {
                    NetworkHandler.sendToClients((WorldServer)this.field_70170_p, this.func_180425_c(), new EffectsRenderPacket((Entity)this, d3, d4, d5, d0, d1 + 0.2, d2, this.color, 4, 1.0f, 1.0f));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_70227_a(RayTraceResult movingObject) {
        boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
        Entity hit = movingObject.field_72308_g;
        if (!this.field_70170_p.field_72995_K) {
            if (hit != null && hit instanceof MovingThrownProjectile) {
                return;
            }
            if (this.field_70235_a != null && hit != null) {
                boolean pvpEnabled = false;
                try {
                    if (this.field_70235_a instanceof EntityPlayerMP) {
                        pvpEnabled = ((EntityPlayerMP)this.field_70235_a).func_184102_h().func_71219_W();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                AxisAlignedBB bb1 = this.func_174813_aQ().func_186662_g(1.0);
                Predicate Targets = Predicates.and((Predicate)EntitySelectors.field_180132_d, ent -> ent != null && ent.func_70067_L() && ent != this.field_70235_a && !(ent instanceof MovingThrownProjectile) && !ent.func_70045_F());
                List splash = this.field_70170_p.func_175674_a((Entity)this, bb1, Targets);
                for (Entity e : splash) {
                    if (e instanceof EntityPlayer && !pvpEnabled || e.func_70045_F()) continue;
                    e.func_70097_a(new EntityDamageSourceIndirect(DamageSource.field_188407_q.field_76373_n, (Entity)this, (Entity)this.field_70235_a).func_76348_h().func_76361_j().func_82726_p(), (float)this.damage);
                    e.func_70015_d(5);
                }
                this.func_70106_y();
            }
            if (movingObject.field_72308_g != null && !(movingObject.field_72308_g instanceof MovingThrownProjectile) && !movingObject.field_72308_g.func_70028_i((Entity)this.field_70235_a)) {
                this.func_174815_a(this.field_70235_a, movingObject.field_72308_g);
                this.func_70106_y();
            }
            if (movingObject.field_72313_a != RayTraceResult.Type.ENTITY || movingObject.field_72308_g != null && !(movingObject.field_72308_g instanceof MovingThrownProjectile)) {
                BlockPos blockpos;
                if (movingObject.field_72313_a == RayTraceResult.Type.BLOCK && flag && this.field_70170_p.func_175623_d(blockpos = movingObject.func_178782_a().func_177972_a(movingObject.field_178784_b))) {
                    this.field_70170_p.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                }
                this.func_70106_y();
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public void setAim(Entity fireball, Entity entity, float p_184547_2_, float p_184547_3_, float p_184547_4_, float p_184547_5_, float p_184547_6_) {
        float f = -MathHelper.func_76126_a((float)(p_184547_3_ * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(p_184547_2_ * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(p_184547_2_ * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(p_184547_3_ * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(p_184547_2_ * ((float)Math.PI / 180)));
        fireball.field_70159_w = entity.field_70159_w;
        fireball.field_70179_y = entity.field_70179_y;
        if (!entity.field_70122_E) {
            fireball.field_70181_x = entity.field_70181_x;
        }
        this.setThrowableHeading(fireball, f, f1, f2, p_184547_5_, p_184547_6_);
    }

    public void setThrowableHeading(Entity fireball, double x, double y, double z, float velocity, float inaccuracy) {
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        fireball.field_70159_w = x *= (double)velocity;
        fireball.field_70181_x = y *= (double)velocity;
        fireball.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        fireball.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        fireball.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        fireball.field_70126_B = fireball.field_70177_z;
        fireball.field_70127_C = fireball.field_70125_A;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        if (compound.func_74764_b("BreathColor")) {
            this.color = compound.func_74762_e("BreathColor");
        }
        if (compound.func_74764_b("frame")) {
            this.frame = compound.func_74762_e("frame");
        }
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74768_a("BreathColor", this.color);
        compound.func_74768_a("frame", this.frame);
        return super.func_189511_e(compound);
    }

    public static interface HitResult
    extends Serializable {
        public void onHit(MovingThrownProjectile var1, RayTraceResult var2, boolean var3);

        public static class EmptyResult
        implements HitResult,
        Serializable {
            @Override
            public void onHit(MovingThrownProjectile entity, RayTraceResult result, boolean isServer) {
            }
        }
    }
}

